"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrderService = void 0;
const common_1 = require("@nestjs/common");
const bullmq_1 = require("@nestjs/bullmq");
const bullmq_2 = require("bullmq");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const order_entity_1 = require("../entities/order.entity");
const customer_entity_1 = require("../entities/customer.entity");
const order_detail_entity_1 = require("../entities/order-detail.entity");
const product_entity_1 = require("../entities/product.entity");
let OrderService = class OrderService {
    orderRepo;
    customerRepo;
    orderDetailRepo;
    productRepo;
    orderQueue;
    constructor(orderRepo, customerRepo, orderDetailRepo, productRepo, orderQueue) {
        this.orderRepo = orderRepo;
        this.customerRepo = customerRepo;
        this.orderDetailRepo = orderDetailRepo;
        this.productRepo = productRepo;
        this.orderQueue = orderQueue;
    }
    async createOrder(dto, customerId) {
        const customer = await this.customerRepo.findOne({ where: { id: Number(customerId) } });
        if (!customer)
            throw new common_1.NotFoundException('Customer not found');
        const order = this.orderRepo.create({
            customer,
            shippingAddress: dto.shippingAddress,
            billingAddress: dto.billingAddress,
            paymentMethod: dto.paymentMethod,
            customerNotes: dto.customerNotes,
        });
        const savedOrder = await this.orderRepo.save(order);
        for (const item of dto.items) {
            const product = await this.productRepo.findOne({ where: { id: item.productId } });
            if (!product)
                throw new common_1.NotFoundException(`Product with ID ${item.productId} not found`);
            const orderDetail = this.orderDetailRepo.create({
                order: savedOrder,
                product,
                quantity: item.quantity,
                unitPrice: item.unitPrice ?? product.price,
            });
            await this.orderDetailRepo.save(orderDetail);
        }
        await this.orderQueue.add('sendEmail', {
            orderId: savedOrder.id,
            email: customer.email,
        });
        const fullOrder = await this.orderRepo.findOne({
            where: { id: savedOrder.id },
            relations: ['orderDetails', 'orderDetails.product', 'customer'],
        });
        if (!fullOrder) {
            throw new common_1.NotFoundException(`Order with ID ${savedOrder.id} not found after creation`);
        }
        return fullOrder;
    }
    async getCustomerOrders(customerId) {
        const customer = await this.customerRepo.findOne({ where: { id: Number(customerId) } });
        if (!customer)
            throw new common_1.NotFoundException('Customer not found');
        return await this.orderRepo.find({
            where: { customer: { id: Number(customerId) } },
            relations: ['orderDetails', 'orderDetails.product'],
            order: { createdAt: 'DESC' },
        });
    }
    async findOrderById(orderId, customerId) {
        const order = await this.orderRepo.findOne({
            where: {
                id: orderId,
                customer: { id: Number(customerId) }
            },
            relations: ['orderDetails', 'orderDetails.product', 'customer'],
        });
        if (!order) {
            throw new common_1.NotFoundException('Order not found');
        }
        return order;
    }
};
exports.OrderService = OrderService;
exports.OrderService = OrderService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(order_entity_1.Order)),
    __param(1, (0, typeorm_2.InjectRepository)(customer_entity_1.Customer)),
    __param(2, (0, typeorm_2.InjectRepository)(order_detail_entity_1.OrderDetail)),
    __param(3, (0, typeorm_2.InjectRepository)(product_entity_1.Product)),
    __param(4, (0, bullmq_1.InjectQueue)('order')),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository,
        typeorm_1.Repository,
        bullmq_2.Queue])
], OrderService);
//# sourceMappingURL=order.service.js.map